	EXPORT	maddalt
	EXPORT	int_on
	EXPORT	int_off
	EXPORT	set_monster_reg
	EXPORT	get_monster_reg
	EXPORT	check_monster
	EXPORT	get_firmware_version

	TEXT

set_monster_reg:
	movem.l	d0-d1,-(sp)
	move.w	$fffe00,d1
	move.w	d0,$fffe00
	move.w	d0,$fffe00
	movem.l	(sp)+,d0-d1
	rts

get_monster_reg:
	move.w	$fffe00,d0
	rts

check_monster:
	move.l	a1,-(sp)
	move.l	8,_save_bus_error_handler
	move.l	#_no_monSTer,8
	move.l	sp,a1

	move.w	#0,d0
	tst.w		$fffe00
	move.w	#1,d0

	; Bus error handler.
_no_monSTer:
	move.l	a1,sp
	move.l	_save_bus_error_handler,8
	move.l	(sp)+,a1
	rts

; PureC Maddalt() is broken.
maddalt:
	move.l	d1,-(sp)		; Size
	move.l	d0,-(sp)		; Addr
	move.w	#20,-(sp)		; Maddalt
	trap	#1				; GEMDOS
	lea		10(sp),sp
	rts

; Using Supexec() to execute these.
int_off:
	pea		off
	move.w	#38,-(sp)
	trap	#14
	addq.l	#6,sp
	rts
off:
	move.w	sr,_save_sr
	move.w	#$2700,sr
	rts

int_on:
	pea		on
	move.w	#38,-(sp)
	trap	#14
	addq.l	#6,sp
	rts
on:
	move.w	_save_sr,sr
	rts

; Attempt to read MonSTer firmware version register.
; Catch bus error in case register doesnt exist.
; Must be called in supervisor mode!
get_firmware_version:
	move.l	a1,-(sp)

	; Install temporary bus error handler
	move.l	8,_save_bus_error_handler
	move.l	#read_word_error,8

	; Save stackpointer before poss. exception
	move.l	sp,a1

	; Default return value
	move.w	#-1,d0

	; Test firmware version register
	tst.w		$fffe08

	; No bus error. Read register
	move.w	$fffe08,d0

	; Bus error handler.
read_word_error:

	; Restore stack pointer -> discard bus error stack frame
	move.l	a1,sp

	; Restore original bus error handler
	move.l	_save_bus_error_handler,8

	; Return
	move.l	(sp)+,a1
	rts
	
	BSS

_save_sr:
	ds.w	1

_save_bus_error_handler:
	ds.l	1
