; Various low-level routines for M_FLASH.
; CRC-stuff from TOS 2.06 by Atari, disassembled by P. Putnik
; The rest by Jo Even Skarstein 2015

	EXPORT reset
	EXPORT fixcrc
	EXPORT set_monster_reg
	EXPORT get_monster_reg
	EXPORT tos_erase
	
	TEXT

set_monster_reg:
	movem.l	d0-d1,-(sp)
	move.w	$fffe00,d1
	move.w	d0,$fffe00
	move.w	d0,$fffe00
	movem.l	(sp)+,d0-d1
	rts

get_monster_reg:
	move.w	$fffe00,d0
	rts

; Erase specified TOS address area.
; d0:
; 0 - last 192KB (TOS 1.x)
; 1 - 512KB flashdisk
; 2 - First 256KB (TOS 2.x)
;
; d1: Flash area base address
;
; NB! Erasing must be done with all interrupts
; disabled. TOS will crash if some interrupt access
; ROM while an erase is in progress.
tos_erase:
	movem.l	d0-d7/a0-a6,-(sp)
	move.w	sr,_save_sr
	move.w	#$2700,sr

	move.l	d1,a0	; Base address

	; Enter sector erase mode
	move.w	#$aaaa,$f0aaaa
	move.w	#$5555,$f05554
	move.w	#$8080,$f0aaaa
	move.w	#$aaaa,$f0aaaa
	move.w	#$5555,$f05554

	; Determine what to erase
	cmp.w	#2,d0
	beq		_tos2_erase
	cmp.w	#1,d0
	beq		_flashdisk_erase
	cmp.w	#0,d0
	beq		_tos1_erase
	bra		_tos_erase_return

	; Erase first 256KB. This is a bit special,
	; because the first four sectors are in total
	; the same size as one regular sector.
	; This is ONLY when the lower MB is mapped to
	; the flash area, but the code works when the
	; upper MB is mapped too.
	; $00000 - $3ffff
_tos2_erase:
	move.w	#$3030,(a0) ; $0000 - First sector
	add.l	#$4000,a0	; $4000
	move.w	#$3030,(a0)
	add.l	#$2000,a0	; $6000
	move.w	#$3030,(a0)
	add.l	#$2000,a0	; $8000
	move.w	#$3030,(a0)
	add.l	#$8000,a0	; $10000 - Following sectors
	move.w	#$3030,(a0)
	add.l	#$10000,a0	; $20000
	move.w	#$3030,(a0)
	add.l	#$10000,a0	; $30000
	move.w	#$3030,(a0)

	move.l	d1,a0			; $00000
	bsr		wait_for_erase
	add.l	#$4000,a0		; $04000
	bsr		wait_for_erase
	add.l	#$2000,a0		; $06000
	bsr		wait_for_erase
	add.l	#$2000,a0		; $08000
	bsr		wait_for_erase
	add.l	#$8000,a0		; $10000
	bsr		wait_for_erase
	add.l	#$10000,a0		; $20000
	bsr		wait_for_erase
	add.l	#$10000,a0		; $30000
	bsr		wait_for_erase
	
	bra		_tos_erase_return

	; Erase the "middle" 512KB (flashdisk)
	; $40000 - $bffff
_flashdisk_erase:
	add.l	#$40000,a0	; $40000
	move.w	#$3030,(a0)
	add.l	#$10000,a0	; $50000
	move.w	#$3030,(a0)
	add.l	#$10000,a0	; $60000
	move.w	#$3030,(a0)
	add.l	#$10000,a0	; $70000
	move.w	#$3030,(a0)
	add.l	#$10000,a0	; $80000
	move.w	#$3030,(a0)
	add.l	#$10000,a0	; $90000
	move.w	#$3030,(a0)
	add.l	#$10000,a0	; $a0000
	move.w	#$3030,(a0)
	add.l	#$10000,a0	; $b0000
	move.w	#$3030,(a0)

	move.l	d1,a0		; Base address
	add.l	#$40000,a0	; $40000
	bsr		wait_for_erase
	add.l	#$10000,a0	; $50000
	bsr		wait_for_erase
	add.l	#$10000,a0	; $60000
	bsr		wait_for_erase
	add.l	#$10000,a0	; $70000
	bsr		wait_for_erase
	add.l	#$10000,a0	; $80000
	bsr		wait_for_erase
	add.l	#$10000,a0	; $90000
	bsr		wait_for_erase
	add.l	#$10000,a0	; $a0000
	bsr		wait_for_erase
	add.l	#$10000,a0	; $b0000
	bsr		wait_for_erase

	bra		_tos_erase_return

	; The last 256KB (TOS 1.x)
	; $c0000 - $fffff
_tos1_erase:
	add.l	#$c0000,a0		;$c0000
	move.w	#$3030,(a0)
	add.l	#$10000,a0		;$d0000
	move.w	#$3030,(a0)
	add.l	#$10000,a0		;$e0000
	move.w	#$3030,(a0)

	move.l	d1,a0
	add.l	#$c0000,a0		;$c0000
	bsr		wait_for_erase
	add.l	#$10000,a0		;$d0000
	bsr		wait_for_erase
	add.l	#$10000,a0		;$e0000
	bsr		wait_for_erase

_tos_erase_return:
	move.w	_save_sr,sr
	movem.l	(sp)+,d0-d7/a0-a6
	rts

; Waits for sector erase to finish
; Sector address in a0
wait_for_erase:
	move.w	(a0),d0
	and.w	#$40,d0
	move.w	(a0),d1
	and.w	#$40,d1
	cmp.w	d0,d1
	bne		wait_for_erase
	rts

; Reset machine
reset:
	clr.l	-(sp)
	move.w	#$20,-(sp)	; Super()
	trap	#1
	add.l	#6,sp
	clr.l		$420.w	; Clear memvalid
	move.w	#$2700,sr	; Disable all interrupts
	reset				; RESET will make MonSTer read side switch
	move.l	#$ffff,d0	; Short delay
_wait:
	dbra	d0,_wait
	move.l	4.w,a0		; Load initial PC from ROM...
	jmp		(a0)		; ...and jump.

;CRC calculation part for TOS 2.06 :
;It is taken (disassembled) from TOS 2.06
;Disassembled by P. Putnik, adapted to pasm by joska.

fixcrc:
	movem.l	d0-d7/a0-a6,-(sp)
	clr.w		crcerf
	move.l	#$1FFFE,d7
	move.w	#1,d6
	move.l	a0,a5	; Pointer to TOS-image in a0
lE0080A:
	move.w	#2,-(sp)
	move.l	d7,-(sp)
	move.l	a5,-(sp)
	bsr.s		getcrc
	add.l		#$A,sp
	movea.l	a5,a0
	adda.l	#$3FFFC,a0
	move.b	(a0),d1
	lsl.w		#8,d1
	move.b	2(a0),d1
	cmp.w		d1,d0
;	bne.s		$E00858
	beq.s		oddcrc
	st 		crcerf	; set flag

oddcrc:
	move.b	d0,2(a0)		; Write new CRC to buffer
 	lsr.w		#8,d0
	move.b	d0,(a0)
	
	addq.l	#1,a5
	dbf		d6,lE0080A
	movem.l	(sp)+,d0-d7/a0-a6
	rts

getcrc:
	movea.l	4(sp),a0
	move.l	8(sp),d2
	movea.w	$C(sp),a1
	clr.w		d0
	clr.w		d1
	clr.w		d3
	lea		crctable,a2
lE015CC:
	move.w	d0,d1
	lsl.w	#8,d0
	lsr.w	#8,d1
	move.b	(a0),d3
	adda.l	a1,a0
	eor.b	d3,d1
	add.w	d1,d1
	move.w	0(a2,d1.w),d4
	eor.w		d4,d0
	subq.l	#1,d2
	bne.s		lE015CC
	rts

; ** End of CRC code **

	BSS

_save_sr:
	ds.l	1

crcerf:
	ds.w	1	; error flag

	DATA

crctable:
	DC.B	0,0,$10,$21,$20,$42,$30,$63
	DC.B	$40,$84,$50,$A5,$60,$C6,$70,$E7
	DC.B	$81,8,$91,$29,$A1,$4A,$B1,$6B
	DC.B	$C1,$8C,$D1,$AD,$E1,$CE,$F1,$EF
	DC.B	$12,$31,2,$10,$32,$73,$22,$52
	DC.B	$52,$B5,$42,$94,$72,$F7,$62,$D6
	DC.B	$93,$39,$83,$18,$B3,$7B,$A3,$5A
	DC.B	$D3,$BD,$C3,$9C,$F3,$FF,$E3,$DE
	DC.B	$24,$62,$34,$43,4,$20,$14,1
	DC.B	$64,$E6,$74,$C7,$44,$A4,$54,$85
	DC.B	$A5,$6A,$B5,$4B,$85,$28,$95,9
	DC.B	$E5,$EE,$F5,$CF,$C5,$AC,$D5,$8D
	DC.B	$36,$53,$26,$72,$16,$11,6,$30
	DC.B	$76,$D7,$66,$F6,$56,$95,$46,$B4
	DC.B	$B7,$5B,$A7,$7A,$97,$19,$87,$38
	DC.B	$F7,$DF,$E7,$FE,$D7,$9D,$C7,$BC
	DC.B	$48,$C4,$58,$E5,$68,$86,$78,$A7
	DC.B	8,$40,$18,$61,$28,2,$38,$23
	DC.B	$C9,$CC,$D9,$ED,$E9,$8E,$F9,$AF
	DC.B	$89,$48,$99,$69,$A9,$A,$B9,$2B
	DC.B	$5A,$F5,$4A,$D4,$7A,$B7,$6A,$96
	DC.B	$1A,$71,$A,$50,$3A,$33,$2A,$12
	DC.B	$DB,$FD,$CB,$DC,$FB,$BF,$EB,$9E
	DC.B	$9B,$79,$8B,$58,$BB,$3B,$AB,$1A
	DC.B	$6C,$A6,$7C,$87,$4C,$E4,$5C,$C5
	DC.B	$2C,$22,$3C,3,$C,$60,$1C,$41
	DC.B	$ED,$AE,$FD,$8F,$CD,$EC,$DD,$CD
	DC.B	$AD,$2A,$BD,$B,$8D,$68,$9D,$49
	DC.B	$7E,$97,$6E,$B6,$5E,$D5,$4E,$F4
	DC.B	$3E,$13,$2E,$32,$1E,$51,$E,$70
	DC.B	$FF,$9F,$EF,$BE,$DF,$DD,$CF,$FC
	DC.B	$BF,$1B,$AF,$3A,$9F,$59,$8F,$78
	DC.B	$91,$88,$81,$A9,$B1,$CA,$A1,$EB
	DC.B	$D1,$C,$C1,$2D,$F1,$4E,$E1,$6F
	DC.B	$10,$80,0,$A1,$30,$C2,$20,$E3
	DC.B	$50,4,$40,$25,$70,$46,$60,$67
	DC.B	$83,$B9,$93,$98,$A3,$FB,$B3,$DA
	DC.B	$C3,$3D,$D3,$1C,$E3,$7F,$F3,$5E
	DC.B	2,$B1,$12,$90,$22,$F3,$32,$D2
	DC.B	$42,$35,$52,$14,$62,$77,$72,$56
	DC.B	$B5,$EA,$A5,$CB,$95,$A8,$85,$89
	DC.B	$F5,$6E,$E5,$4F,$D5,$2C,$C5,$D
	DC.B	$34,$E2,$24,$C3,$14,$A0,4,$81
	DC.B	$74,$66,$64,$47,$54,$24,$44,5
	DC.B	$A7,$DB,$B7,$FA,$87,$99,$97,$B8
	DC.B	$E7,$5F,$F7,$7E,$C7,$1D,$D7,$3C
	DC.B	$26,$D3,$36,$F2,6,$91,$16,$B0
	DC.B	$66,$57,$76,$76,$46,$15,$56,$34
	DC.B	$D9,$4C,$C9,$6D,$F9,$E,$E9,$2F
	DC.B	$99,$C8,$89,$E9,$B9,$8A,$A9,$AB
	DC.B	$58,$44,$48,$65,$78,6,$68,$27
	DC.B	$18,$C0,8,$E1,$38,$82,$28,$A3
	DC.B	$CB,$7D,$DB,$5C,$EB,$3F,$FB,$1E
	DC.B	$8B,$F9,$9B,$D8,$AB,$BB,$BB,$9A
	DC.B	$4A,$75,$5A,$54,$6A,$37,$7A,$16
	DC.B	$A,$F1,$1A,$D0,$2A,$B3,$3A,$92
	DC.B	$FD,$2E,$ED,$F,$DD,$6C,$CD,$4D
	DC.B	$BD,$AA,$AD,$8B,$9D,$E8,$8D,$C9
	DC.B	$7C,$26,$6C,7,$5C,$64,$4C,$45
	DC.B	$3C,$A2,$2C,$83,$1C,$E0,$C,$C1
	DC.B	$EF,$1F,$FF,$3E,$CF,$5D,$DF,$7C
	DC.B	$AF,$9B,$BF,$BA,$8F,$D9,$9F,$F8
	DC.B	$6E,$17,$7E,$36,$4E,$55,$5E,$74
	DC.B	$2E,$93,$3E,$B2,$E,$D1,$1E,$F0
	DC.B	0,$1B,$31,$32,$33,$34,$35,$36
	DC.B	$37,$38,$39,$30,$2D,$3D,8,9
	DC.B	$71,$77,$65,$72,$74,$79,$75,$69
	DC.B	$6F,$70,$5B,$5D,$D,0,$61,$73
	DC.B	$64,$66,$67,$68,$6A,$6B,$6C,$3B
	DC.B	$27,$60,0,$23,$7A,$78,$63,$76
	DC.B	$62,$6E,$6D,$2C,$2E,$2F,0,0
	DC.B	0,$20,0,0,0,0
