#include <aes.h>
#include <assert.h>

enum {false, true};

/*

   Crude popup menu for plain TOS. Code not usable in the general case!

*/

static int wait_mouse(int *mx, int *my, int *mbuttons, int *modifiers)
{
	int msg[8], scancode, clicks;

	evnt_multi(MU_KEYBD|MU_BUTTON|MU_M1,
		1, 1, 1, /* Mouse button */
		1, *mx, *my, 1, 1, /* M1 */
		0,0,0,0,0, /* M2 */
		msg,
		0,0, /* Timer */
		mx, my, mbuttons, modifiers,
		&scancode, &clicks); 

	/*** FIX THIS! Why does evnt_multi return the "wrong" mousebutton state? ***/
	graf_mkstate(mx, my, mbuttons, modifiers);
	return 1;
}

int do_popup(OBJECT *tree, int obj, int x, int y)
{
	int mx, my, mbuttons, modifiers, mbstate;

	assert(tree && obj >= 0);

	/* Set width of all menu objects equal to menu root. */
	{
		int i = tree[obj].ob_head;
	
		tree[obj].ob_x = x;
		tree[obj].ob_y = y;
		
		while (i != obj)
		{
			tree[i].ob_width = tree[obj].ob_width;
			tree[i].ob_state &= ~SELECTED;
			i = tree[i].ob_next;
		}
	}

	/* Draw menu */
	objc_draw(tree, obj, 7, x-5, y-5, tree[obj].ob_width+10, tree[obj].ob_height+10);
	graf_mkstate(&mx, &my, &mbstate, &modifiers);
	mbuttons = mbstate;

	/* Interact with menu, exit when mouse button is clicked */
	do
	{
		int i = objc_find(tree, obj, 7, mx, my);

		if (mbuttons != mbstate) /* Button state changed */
		{
			while (mbuttons)
				graf_mkstate(&mx, &my, &mbuttons, &modifiers);

			if (tree[i].ob_state & SELECTED)
				return i;
			else
				return -1;
		}

		if (i != -1 && i != obj) /* Not error and not root */
		{
			if (!(tree[i].ob_state & SELECTED)) /* Menu item under mouse not selected */
			{
				int o = tree[obj].ob_head, update = 0;
				
				/* DeSELECT all menu items */
				while (o != obj)
				{
					if (tree[o].ob_state & SELECTED)
					{
						tree[o].ob_state &= ~SELECTED;
						update = true;
					}
					
					o = tree[o].ob_next;
				}

				/* SELECT object under mouse */
				if (!(tree[i].ob_state & DISABLED))
				{
					tree[i].ob_state |= SELECTED;
					update = true;
				}

				if (update)
					objc_draw(tree, obj, 7, tree[obj].ob_x, tree[obj].ob_y,
						tree[obj].ob_width, tree[obj].ob_height);
			}
		}
	} while (wait_mouse(&mx, &my, &mbuttons, &modifiers));

	return -1;
}
